//package globalExamples;

import oracle.olapi.data.cursor.Cursor;

import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.NumberParameter;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.NotCommittableException;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 7-16, Selecting a Range With NumberParameter 
 * Objects, in Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class SelectingRangeWithNumberParam 
{
  public SelectingRangeWithNumberParam()
  {
  }

  public void run(String[] args) 
  {
    Context10g context = new Context10g(args, false);
    context.println("Example 7-16, Selecting a Range With NumberParameter Objects");
    
    // Get the MdmMeasure for units sold
    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");
    // Get the Source for the measure
    Source units = mdmUnits.getSource();

    // Get the dimensions of the measure and the default hierarchies of
    // the dimensions
    MdmPrimaryDimension[] mdmPrimDims = 
         context.getMdmPrimaryDimensionsByName(new String[]
                                               {"PRODUCT", 
                                                "TIME",
                                                "CHANNEL",
                                                "CUSTOMER"});

    MdmPrimaryDimension mdmProdDim = mdmPrimDims[0];
    //StringSource prodDim = (StringSource) mdmProdDim.getSource();
    MdmLevelHierarchy mdmProdDefLvlHier = (MdmLevelHierarchy)
                                           mdmProdDim.getDefaultHierarchy();
    
    MdmPrimaryDimension mdmTimeDim = mdmPrimDims[1];
    MdmLevelHierarchy mdmTimeDefLvlHier = (MdmLevelHierarchy)
                                           mdmTimeDim.getDefaultHierarchy();

    MdmPrimaryDimension mdmChanDim = mdmPrimDims[2];
    MdmLevelHierarchy mdmChanDefLvlHier = (MdmLevelHierarchy)
                                           mdmChanDim.getDefaultHierarchy();

    MdmPrimaryDimension mdmCustDim = mdmPrimDims[3];
    MdmLevelHierarchy mdmCustDefLvlHier = (MdmLevelHierarchy)
                                           mdmCustDim.getDefaultHierarchy();
 
    // Get the Source objects for the hierarchies
    StringSource prodRollup = (StringSource) mdmProdDefLvlHier.getSource();
    StringSource calendar = (StringSource) mdmTimeDefLvlHier.getSource();
    StringSource chanRollup = (StringSource) mdmChanDefLvlHier.getSource();
    StringSource shipRollup = (StringSource) mdmCustDefLvlHier.getSource();

    // Get the DataProvider
    DataProvider dp = context.getDataProvider();

    // Create NumberParameter objects for the starting and ending values 
    // of the range.
    NumberParameter startParam = new NumberParameter(dp, 1);
    NumberParameter endParam = new NumberParameter(dp, 6);

    // Create parameterized Source objects.
    NumberSource startParamSrc = dp.createParameterizedSource(startParam);
    NumberSource endParamSrc = dp.createParameterizedSource(endParam);

    // Specify a set of positions of the products dimension using the 
    // parameterized Source objects.
    Source paramProdSelInterval = prodRollup.interval(startParamSrc,
                                                    endParamSrc);
    // Get the short description attribute for the Product dimension and
    // get the Source for the attribute
    MdmAttribute mdmProdShortDescr = 
                               mdmProdDim.getShortValueDescriptionAttribute();
    Source prodShortDescr = mdmProdShortDescr.getSource();

    // Join the selected products to the short descriptions   
    Source paramProdSelIntervalShortDescr = 
                                    prodShortDescr.join(paramProdSelInterval);

    // Join units to selected values from three of the dimensions.
    // These join shortcuts hide the output.
    // Join the parameterized Source, also.
    NumberSource result = (NumberSource) 
                            units.join(chanRollup, "CHANNEL_ROLLUP::CHANNEL::4")
                                 .join(calendar, "CALENDAR::YEAR::4")
                                 .join(shipRollup, 
                                       "SHIPMENTS_ROLLUP::ALL_CUSTOMERS::1")
                                 .join(paramProdSelIntervalShortDescr);

    // Get the TransactionProvider
    TransactionProvider tp = context.getTransactionProvider();
    // Prepare and commit the current transaction
    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e)
    {
      context.println("Cannot prepare the current Transaction. " +
              "Caught exception " + e + ".");
    }
    tp.commitCurrentTransaction();

    // Create a Cursor
    CursorManagerSpecification cMngrSpec = 
                 dp.createCursorManagerSpecification(result);
    SpecifiedCursorManager  spCMngr = dp.createCursorManager(cMngrSpec);
    Cursor resultCursor = spCMngr.createCursor();

    // Display the results
    context.displayCursor(resultCursor);

    //Reset the Cursor position to 1;
     resultCursor.setPosition(1);

     //Change the value of the parameterized Source
     startParam.setValue(7);
     endParam.setValue(12);
    
    // Using the same Cursor, display the results again
    context.println(" ");
    context.displayCursor(resultCursor);    
  }

  public static void main(String[] args)
  {
    new SelectingRangeWithNumberParam().run(args);
  }
}
